/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.libzoomer.api;

import io.github.ennuil.libzoomer.api.ZoomInstance;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;

public class ZoomRegistry {
    private static final Set<ZoomInstance> zoomInstances = new ReferenceArraySet();
    private static boolean iterateZoom;
    private static boolean iterateTransitions;
    private static boolean iterateModifiers;
    private static boolean iterateOverlays;

    @ApiStatus.Internal
    protected static ZoomInstance registerInstance(ZoomInstance instance) {
        for (ZoomInstance zoomInstance : zoomInstances) {
            if (!zoomInstance.getInstanceId().equals((Object)instance.getInstanceId())) continue;
            throw new RuntimeException("Multiple zoom instances with the ID " + zoomInstance.getInstanceId() + " were found!");
        }
        return zoomInstances.add(instance) ? instance : null;
    }

    public static Set<ZoomInstance> getZoomInstances() {
        return zoomInstances;
    }

    public static boolean shouldIterateZoom() {
        return iterateZoom;
    }

    @ApiStatus.Internal
    public static void setIterateZoom(boolean iterateZoom) {
        ZoomRegistry.iterateZoom = iterateZoom;
    }

    public static boolean shouldIterateTransitions() {
        return iterateTransitions;
    }

    @ApiStatus.Internal
    public static void setIterateTransitions(boolean iterateTransitions) {
        ZoomRegistry.iterateTransitions = iterateTransitions;
    }

    public static boolean shouldIterateModifiers() {
        return iterateModifiers;
    }

    @ApiStatus.Internal
    public static void setIterateModifiers(boolean iterateModifiers) {
        ZoomRegistry.iterateModifiers = iterateModifiers;
    }

    public static boolean shouldIterateOverlays() {
        return iterateOverlays;
    }

    @ApiStatus.Internal
    public static void setIterateOverlays(boolean iterateOverlays) {
        ZoomRegistry.iterateOverlays = iterateOverlays;
    }
}

